"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cell = void 0;
var container_2d_class_1 = require("../container-2d.class");
var Cell = /** @class */ (function () {
    function Cell(parent, x, y, _value) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this._value = _value;
        container_2d_class_1.Container2D.checkCoordinates(x, y);
    }
    Cell.defaultRenderer = function (value) {
        var str = '';
        if (typeof value === 'string') {
            str = value;
        }
        else if (value === true) {
            str = '✓';
        }
        else if (value === false) {
            str = '✗';
        }
        else if (typeof value === 'number' || typeof value === 'bigint' || (value && typeof value === 'object')) {
            str = String(value);
        }
        return str;
    };
    Object.defineProperty(Cell.prototype, "value", {
        get: function () {
            return this._value;
        },
        set: function (value) {
            if (typeof value === 'function' || (value && typeof value === 'object') || typeof value === 'symbol') {
                value = String(value);
            }
            this._value = value;
        },
        enumerable: false,
        configurable: true
    });
    return Cell;
}());
exports.Cell = Cell;
