interface Node2D<TV> {
    x: number;
    y: number;
    value: TV;
}
declare type DataClass<TV, T extends Node2D<TV>, TP> = {
    new (parent: TP, x: number, y: number, value: TV): T;
    constructor: Function;
};
export declare abstract class Container2D<TV, T extends Node2D<TV>, TP> {
    protected readonly DataClass: DataClass<TV, T, TP>;
    protected readonly defaultValueFn: () => TV;
    static checkCoordinate(coord: number): void;
    static checkCoordinates(x: number, y: number): void;
    protected readonly _list: T[];
    constructor(DataClass: DataClass<TV, T, TP>, defaultValueFn: () => TV);
    clear(): void;
    count(matchFn: (item: T) => boolean): number;
    filter(matchFn: (item: T) => boolean): T[];
    flip(): void;
    getsert(x: number, y: number): T;
    indices(matchFn: (item: T) => boolean): number[];
    max(numberValFn: (item: T) => number, min?: number): number;
    remove(matchFn: (item: T) => boolean): void;
    splice(vertical: boolean, i: number, remove: number, insert?: number): void;
    upsert(x: number, y: number, value: TV): void;
    protected sort(): void;
}
export {};
