"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.outputFormatterMarkdown = void 0;
var pipeRx = /\|/g;
var spacedContentRx = /^(\s*)(.*[^\s])(\s*)$/;
// eslint-disable-next-line @typescript-eslint/no-unused-vars
function outputFormatterMarkdown(renderData, options) {
    var cellConfig = renderData.cellConfig, cellValueRendered = renderData.cellValueRendered, columnWidth = renderData.columnWidth, columns = renderData.columns, rows = renderData.rows, startX = renderData.startX, startY = renderData.startY;
    var out = '';
    if (startY === 0) {
        for (var x = startX; x < columns; x++) {
            out += '|' + ' '.repeat(columnWidth[x] + 2);
        }
        out += '|\n';
    }
    for (var y = startY; y < rows; y++) {
        if (y === 0) {
            for (var x = startX; x < columns; x++) {
                var cellConfigs = cellConfig[x];
                var rightCount = cellConfigs.filter(function (config) { return config.align === 'right'; }).length;
                var centerCount = cellConfigs.filter(function (config) { return config.align === 'center'; }).length;
                var align = (rightCount > rows / 2 ? 'right' : centerCount > rows / 2 ? 'center' : undefined);
                out += '|' + (align === 'center' ? ':' : '-') + '-'.repeat(columnWidth[x]) + (align ? ':' : '-');
            }
            out += '|\n';
        }
        var targetLen = 0;
        var rowLen = 0;
        for (var x = startX; x < columns; x++) {
            var rendered = cellValueRendered[x][y];
            var width = columnWidth[x];
            var content = (rendered.trim() ? rendered.split('\n').join('<br>') : ' '.repeat(width))
                .replace(pipeRx, '&#124;');
            var _a = cellConfig[x][y], bold = _a.bold, italic = _a.italic, link = _a.link;
            if (!!content.trim()) {
                var pre = (italic ? '_' : '') + (bold ? '**' : '') + (link ? '[' : '');
                var post = (link ? "](".concat(link, ")") : '') + (bold ? '**' : '') + (italic ? '_' : '');
                content = content.replace(spacedContentRx, "$1".concat(pre, "$2").concat(post, "$3"));
            }
            content = ' ' + content + (content.length < width ? ' '.repeat(width - content.length) : '') + ' ';
            targetLen += width + 3;
            rowLen += 1 + content.length;
            while (rowLen > targetLen && !content[content.length - 1].trim()) {
                content = content.substring(0, content.length - 1);
                rowLen--;
            }
            while (rowLen > targetLen && !content[0].trim()) {
                content = content.substring(1);
                rowLen--;
            }
            out += '|' + content;
        }
        out += '|\n';
    }
    return out;
}
exports.outputFormatterMarkdown = outputFormatterMarkdown;
