"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TableSnapshot = void 0;
var TableSnapshot = /** @class */ (function () {
    function TableSnapshot(table) {
        if (table instanceof TableSnapshot) {
            Object.assign(this, table); // clone
        }
        else {
            this.columns = table.columns;
            this.rows = table.rows;
            this.columnHeaders = table.getColumnHeaders();
            this.startY = this.columnHeaders ? -1 : 0;
            this.rowHeaders = table.getRowHeaders();
            this.startX = this.rowHeaders ? -1 : 0;
            this.tableConfig = table.getTableConfig();
            this.cellConfig = [];
            this.cellValue = [];
            this.columnConfig = [];
            for (var x = this.startX; x < this.columns; x++) {
                this.columnConfig[x] = table.getColumnConfig(x);
                this.cellConfig[x] = [];
                this.cellValue[x] = [];
                for (var y = this.startY; y < this.rows; y++) {
                    this.cellConfig[x][y] = table.getCellRenderConfig(x, y);
                    this.cellValue[x][y] = table.getCell(x, y);
                }
            }
            this.rowConfig = [];
            for (var y = this.startY; y < this.rows; y++) {
                this.rowConfig[y] = table.getRowConfig(y);
            }
        }
    }
    return TableSnapshot;
}());
exports.TableSnapshot = TableSnapshot;
