"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Config = exports.CONFIG_VALIGN = exports.CONFIG_ALIGN = void 0;
exports.CONFIG_ALIGN = ['center', 'left', 'right'];
var CONFIG_BORDERS = ['borderBottom', 'borderLeft', 'borderRight', 'borderTop'];
var CONFIG_COLORS = ['black', 'blue', 'cyan', 'default', 'green', 'magenta', 'red', 'white', 'yellow'];
exports.CONFIG_VALIGN = ['bottom', 'middle', 'top'];
var CONFIG_SIZES = ['height', 'maxHeight', 'maxWidth', 'width'];
var CONFIG_BORDER_FLIP_PAIRS = {
    borderBottom: 'borderRight',
    borderLeft: 'borderTop',
    borderRight: 'borderBottom',
    borderTop: 'borderLeft'
};
/** [axis, isStarter, prop-of-cells-for-edge] */
var CONFIG_BORDER_REFS = {
    borderBottom: ['y', false, 'rows'],
    borderLeft: ['x', true, 'startX'],
    borderRight: ['x', false, 'columns'],
    borderTop: ['y', true, 'startY']
};
var Config = /** @class */ (function () {
    function Config(parent, x, y, _value) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this._value = _value;
    }
    Config.sanitizeAlign = function (input, fallback) {
        if (fallback === void 0) { fallback = 'left'; }
        var lc = String(input).toLowerCase();
        return exports.CONFIG_ALIGN.includes(lc) ? lc : fallback;
    };
    Config.sanitizeVAlign = function (input, fallback) {
        if (fallback === void 0) { fallback = 'top'; }
        var lc = String(input).toLowerCase();
        return exports.CONFIG_VALIGN.includes(lc) ? lc : fallback;
    };
    Object.defineProperty(Config.prototype, "renderConfig", {
        get: function () {
            var columnConfig = this.parent.getColumn(this.x).value;
            var rowConfig = this.parent.getRow(this.y).value;
            var mesh = Object.assign(this.parent.table.value, rowConfig, columnConfig, this.value);
            var _a = this.parent.cells, startX = _a.startX, startY = _a.startY;
            mesh.borderBottom = this.parent.getsert(this.x, this.y + 1).borderValue('borderTop') || this.borderValue('borderBottom');
            mesh.borderLeft = (this.x > startX ?
                this.parent.getsert(this.x - 1, this.y).borderValue('borderRight') : undefined) || this.borderValue('borderLeft');
            mesh.borderRight = this.parent.getsert(this.x + 1, this.y).borderValue('borderLeft') || this.borderValue('borderRight');
            mesh.borderTop = (this.y > startY ?
                this.parent.getsert(this.x, this.y - 1).borderValue('borderBottom') : undefined) || this.borderValue('borderTop');
            return mesh;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Config.prototype, "value", {
        /** read and add defaults */
        get: function () {
            var preferences = this.parent.preferences.value;
            var defaults = {};
            if (this.x == null && this.y == null) { // table
                defaults.borderTop = defaults.borderRight = defaults.borderLeft = defaults.borderBottom = !!preferences.tableBorders;
                defaults.valign = Config.sanitizeVAlign(preferences.valign);
            }
            else if (this.x == null) { // row
                if (this.y === -1) { // header
                    defaults.align = Config.sanitizeAlign(preferences.columnHeaderAlign);
                    defaults.bold = !!preferences.boldHeaders;
                    defaults.borderBottom = !!preferences.headerBorders;
                    defaults.valign = Config.sanitizeVAlign(preferences.columnHeaderVAlign);
                }
                else if (this.y > 0) {
                    defaults.borderTop = !!preferences.horizontalBorders;
                }
            }
            else if (this.y == null) { // column
                if (this.x === -1) { // header
                    defaults.align = Config.sanitizeAlign(preferences.rowHeaderAlign);
                    defaults.bold = !!preferences.boldHeaders;
                    defaults.borderRight = !!preferences.headerBorders;
                    defaults.valign = Config.sanitizeVAlign(preferences.rowHeaderVAlign);
                }
                else if (this.x > 0) {
                    defaults.borderLeft = !!preferences.verticalBorders;
                }
            }
            else if (this.x === -1 && this.y === -1) { // no top/left borders for -1,-1 by default
                defaults.borderLeft = false;
                defaults.borderTop = false;
            }
            return Object.assign(defaults, this._value);
        },
        /** sanitze and update */
        set: function (config) {
            var sane = {};
            if (config && typeof config === 'object') {
                if ('align' in config) {
                    var align = config.align;
                    sane.align = exports.CONFIG_ALIGN.includes(align) ? align : undefined;
                }
                if ('valign' in config) {
                    var valign = config.valign;
                    sane.valign = exports.CONFIG_VALIGN.includes(valign) ? valign : undefined;
                }
                if ('color' in config) {
                    var color = config.color;
                    sane.color = CONFIG_COLORS.includes(color) ? color : undefined;
                }
                if ('link' in config) {
                    sane.link = typeof config.link === 'string' && config.link.trim() || undefined;
                }
                for (var _i = 0, _a = __spreadArray(__spreadArray(['bold'], CONFIG_BORDERS, true), ['italic'], false); _i < _a.length; _i++) {
                    var booleanKey = _a[_i];
                    if (booleanKey in config) {
                        sane[booleanKey] = config[booleanKey] == null ? undefined : !!config[booleanKey];
                    }
                }
                var shorthands = {
                    border: ['borderTop', 'borderRight', 'borderBottom', 'borderLeft'],
                    horizontalBorder: ['borderTop', 'borderBottom'],
                    verticalBorder: ['borderRight', 'borderLeft']
                };
                for (var _b = 0, _c = Object.entries(shorthands); _b < _c.length; _b++) {
                    var _d = _c[_b], shorthand = _d[0], keys = _d[1];
                    if (shorthand in config) {
                        for (var _e = 0, keys_1 = keys; _e < keys_1.length; _e++) {
                            var key = keys_1[_e];
                            if (!(key in sane)) {
                                sane[key] = config[shorthand] == null ? undefined : !!config[shorthand];
                            }
                        }
                    }
                }
                for (var _f = 0, CONFIG_SIZES_1 = CONFIG_SIZES; _f < CONFIG_SIZES_1.length; _f++) {
                    var key = CONFIG_SIZES_1[_f];
                    if (key in config) {
                        var nval = Math.round(+config[key]);
                        sane[key] = nval > 0 ? nval : undefined;
                    }
                }
                if ('renderer' in config) {
                    var fn = config.renderer;
                    sane.renderer = typeof fn === 'function' ? fn : undefined;
                }
            }
            Object.assign(this._value, sane);
        },
        enumerable: false,
        configurable: true
    });
    Config.prototype.borderValue = function (prop) {
        var _a, _b, _c;
        var _d = CONFIG_BORDER_REFS[prop], axis = _d[0], isStarter = _d[1], edgeProp = _d[2];
        var isEdge = (this[axis] === this.parent.cells[edgeProp] - (isStarter ? 0 : 1));
        return ((_c = (_b = (_a = this.value[prop]) !== null && _a !== void 0 ? _a : (axis === 'x' || isEdge ? this.parent.getColumn(this.x).value[prop] : undefined)) !== null && _b !== void 0 ? _b : (axis === 'y' || isEdge ? this.parent.getRow(this.y).value[prop] : undefined)) !== null && _c !== void 0 ? _c : (isEdge ? this.parent.table.value[prop] : undefined)) ||
            false;
    };
    Config.prototype.clear = function () {
        for (var _i = 0, _a = Object.keys(this._value); _i < _a.length; _i++) {
            var key = _a[_i];
            delete this._value[key];
        }
    };
    Config.prototype.flipBorders = function () {
        var tmp = {};
        for (var _i = 0, _a = Object.keys(CONFIG_BORDER_FLIP_PAIRS); _i < _a.length; _i++) {
            var key = _a[_i];
            if (this._value[key] != null) {
                tmp[CONFIG_BORDER_FLIP_PAIRS[key]] = this._value[key];
                delete this._value[key];
            }
        }
        Object.assign(this._value, tmp);
    };
    return Config;
}());
exports.Config = Config;
