"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Configs = void 0;
var container_2d_class_1 = require("../container-2d.class");
var table_class_1 = require("../table.class");
var config_class_1 = require("./config.class");
var preferences_class_1 = require("./preferences.class");
var Configs = /** @class */ (function (_super) {
    __extends(Configs, _super);
    function Configs(cells) {
        var _this = _super.call(this, config_class_1.Config, function () { return ({}); }) || this;
        _this.cells = cells;
        _this.table = new config_class_1.Config(_this, undefined, undefined, {});
        _this._columns = [];
        _this._rows = [];
        _this.preferences = new preferences_class_1.Preferences(table_class_1.Table.getPreferences());
        return _this;
    }
    Configs.prototype.clear = function () {
        this.table.clear();
        this._columns.length = 0;
        delete this._columns[-1];
        this._rows.length = 0;
        delete this._rows[-1];
        _super.prototype.clear.call(this);
    };
    Configs.prototype.flip = function () {
        var _a;
        var _b, _c;
        this.table.flipBorders();
        var _d = this.cells, columns = _d.columns, rows = _d.rows, startX = _d.startX, startY = _d.startY;
        for (var x = startX; x < columns; x++) {
            (_b = this._columns[x]) === null || _b === void 0 ? void 0 : _b.flipBorders();
        }
        for (var y = startY; y < rows; y++) {
            (_c = this._rows[y]) === null || _c === void 0 ? void 0 : _c.flipBorders();
        }
        _a = [this._rows, this._columns], this._columns = _a[0], this._rows = _a[1];
        __spreadArray(__spreadArray(__spreadArray([this._columns[-1]], this._columns, true), [this._rows[-1]], false), this._rows, true).forEach(function (item) {
            var _a;
            if (item) {
                _a = [item.y, item.x], item.x = _a[0], item.y = _a[1];
            }
        });
        this._list.forEach(function (config) { return config.flipBorders(); });
        _super.prototype.flip.call(this);
    };
    Configs.prototype.getColumn = function (x) {
        container_2d_class_1.Container2D.checkCoordinate(x);
        return this._columns[x] = (this._columns[x] || new config_class_1.Config(this, x, undefined, {}));
    };
    Configs.prototype.getRow = function (y) {
        container_2d_class_1.Container2D.checkCoordinate(y);
        return this._rows[y] = (this._rows[y] || new config_class_1.Config(this, undefined, y, {}));
    };
    Configs.prototype.setColumn = function (x, config) {
        this.getColumn(x).value = config;
    };
    Configs.prototype.setRow = function (y, config) {
        this.getRow(y).value = config;
    };
    Configs.prototype.splice = function (vertical, i, remove, insert) {
        if (insert === void 0) { insert = 0; }
        _super.prototype.splice.call(this, vertical, i, remove, insert);
        remove = remove > 0 ? Math.floor(remove) : 0;
        insert = insert > 0 ? Math.floor(insert) : 0;
        var meta = vertical ? this._columns : this._rows;
        if (remove) {
            if (i === -1) {
                delete meta[-1];
                remove--;
                insert && insert--;
            }
        }
        if (remove || insert) {
            meta.splice.apply(meta, __spreadArray([i, remove], Array(insert), false));
            var axis = vertical ? 'x' : 'y';
            for (var ii = i - remove + insert; ii < meta.length; ii++) {
                if (meta[ii]) {
                    meta[ii][axis] = ii;
                }
            }
        }
    };
    return Configs;
}(container_2d_class_1.Container2D));
exports.Configs = Configs;
