import { PreferencesValue } from './config/preferences-value.type';
import { TableRenderBorderData } from './table-render-border-data.class';
import { TableSnapshot } from './table-snapshot.class';
/**
 * Render information for custom table formatters
 */
export declare class TableRenderData extends TableSnapshot {
    /** border information in a grid logic */
    readonly borders: TableRenderBorderData;
    /** processed cell values on (x, y) coordinates */
    readonly cellValueRendered: string[][];
    /** processed cell values split into fixed-width lines on (x, y) coordinates */
    readonly cellValueRenderedMultiline: string[][][];
    /** processed column width on (x) coordinate */
    readonly columnWidth: number[];
    /** processed row height (line count) on (y) coordinate */
    readonly rowHeight: number[];
    /**
     * Instantiate render data
     * @param snapshot Table data snapshot
     */
    constructor(snapshot: TableSnapshot, preferences: PreferencesValue);
}
