"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class TrackMap {
    constructor() {
        this.filter = [];
        this.expression = [];
        this.precedenceGroup = [];
        this.attributeGroup = [];
        this.prefixLogicalExpression = [];
        this.prefixLogicalExpressionOperator = [];
        this.infixLogicalExpression = [];
        this.infixLogicalExpressionPredicate = [];
        this.infixLogicalExpressionOperator = [];
        this.postfixAssertion = [];
        this.postfixAssertionOperator = [];
        this.infixAssertion = [];
        this.infixAssertionOperator = [];
        this.infixAssertionValue = [];
        this.attributePath = [];
        this.attributePathSegment = [];
    }
}
class Stat {
    constructor() {
        this.filter = 0;
        this.expression = 0;
        this.precedenceGroup = 0;
        this.attributeGroup = 0;
        this.prefixLogicalExpression = 0;
        this.prefixLogicalExpressionOperator = 0;
        this.infixLogicalExpression = 0;
        this.infixLogicalExpressionPredicate = 0;
        this.infixLogicalExpressionOperator = 0;
        this.postfixAssertion = 0;
        this.postfixAssertionOperator = 0;
        this.infixAssertion = 0;
        this.infixAssertionOperator = 0;
        this.infixAssertionValue = 0;
        this.attributePath = 0;
        this.attributePathSegment = 0;
    }
}
class StatsMap {
    constructor() {
        this.filter = [];
        this.expression = [];
        this.precedenceGroup = [];
        this.attributeGroup = [];
        this.prefixLogicalExpression = [];
        this.prefixLogicalExpressionOperator = [];
        this.infixLogicalExpression = [];
        this.infixLogicalExpressionPredicate = [];
        this.infixLogicalExpressionOperator = [];
        this.postfixAssertion = [];
        this.postfixAssertionOperator = [];
        this.infixAssertion = [];
        this.infixAssertionOperator = [];
        this.infixAssertionValue = [];
        this.attributePath = [];
        this.attributePathSegment = [];
    }
}
class Yard {
    constructor() {
        this.stats = new StatsMap();
        this.tracks = new TrackMap();
    }
    pre(identifier) {
        this.stats[identifier].push(Object.keys(this.tracks).reduce((acc, k) => {
            acc[k] = this.tracks[k].length;
            return acc;
        }, {}));
    }
    post(identifier) {
        const stats = this.stats[identifier].pop();
        if (!stats) {
            throw new Error(`INVARIANT: stats are missing for type \`${identifier}\`.`);
        }
        return Object.keys(this.tracks).reduce((acc, k) => {
            while (this.tracks[k].length > stats[k]) {
                acc[k].push(this.tracks[k].pop());
            }
            return acc;
        }, new TrackMap());
    }
}
exports.Yard = Yard;
//# sourceMappingURL=Yard.js.map